﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about discharge orders managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "DischargeOrder")]
    [DataContract(Name = "DischargeOrder")]
    [KnownType(typeof(Order))]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class DischargeOrder : Order
    {
        /// <summary>
        /// Gets or sets the medical person id that schedules the movement(EIS person).
        /// </summary>
        /// <value>
        /// The scheduler id.
        /// </value>
        [XmlElementAttribute("SchedulerId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "SchedulerId", Order = 1)]
        public II SchedulerId { get; set; }

        /// <summary>
        /// Gets or sets the orderable item.
        /// </summary>
        /// <value>
        /// The orderable item.
        /// </value>
        [XmlElementAttribute("OrderableItem", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "OrderableItem", Order = 2)]
        public CD OrderableItem { get; set; }
    }
}
